module dbemsa
  implicit none

contains
  function demsav(drdx,c,m,p,flag) result(grad)
    implicit none
    real,dimension(15,10)::drdx
    real,dimension(0:207)::c
    real,dimension(0:495)::m
    real,dimension(0:207)::p
    real::grad
    integer::flag
    ! ::::::::::::::::::::
    real,dimension(0:207)::dp

    call dbemsav(drdx,dp,m,p,flag)
    grad = dot_product(dp,c)

    return
  end function demsav

  subroutine dbemsav(drdx,dp,m,p,flag)
    implicit none
    real,dimension(15,10),intent(in)::drdx
    real,dimension(0:207),intent(out)::dp
    real,dimension(0:495),intent(in)::m
    real,dimension(0:207),intent(in)::p
    integer::flag
    ! ::::::::::::::::::::
    real,dimension(0:495)::dm

    call devmono(drdx,dm,m,flag)
    call devpoly(dm,p,dp)

    return
  end subroutine dbemsav

  subroutine devmono(drdx,dm,m,flag)
    implicit none
    real,dimension(15,10),intent(in)::drdx
    real,dimension(0:495),intent(out)::dm
    real,dimension(0:495),intent(in)::m
    integer::flag
    !::::::::::::::::::::
    real::a

    a = 2.d0

    dm(0) = 0.0D0
    dm(1) = -m(1)/a*drdx(flag,10)
    dm(2) = -m(2)/a*drdx(flag,9)
    dm(3) = -m(3)/a*drdx(flag,7)
    dm(4) = -m(4)/a*drdx(flag,4)
    dm(5) = -m(5)/a*drdx(flag,8)
    dm(6) = -m(6)/a*drdx(flag,6)
    dm(7) = -m(7)/a*drdx(flag,5)
    dm(8) = -m(8)/a*drdx(flag,3)
    dm(9) = -m(9)/a*drdx(flag,2)
    dm(10) = -m(10)/a*drdx(flag,1)
    dm(11) = dm(1)*m(2) + m(1)*dm(2)
    dm(12) = dm(1)*m(3) + m(1)*dm(3)
    dm(13) = dm(2)*m(3) + m(2)*dm(3)
    dm(14) = dm(1)*m(4) + m(1)*dm(4)
    dm(15) = dm(2)*m(4) + m(2)*dm(4)
    dm(16) = dm(3)*m(4) + m(3)*dm(4)
    dm(17) = dm(3)*m(5) + m(3)*dm(5)
    dm(18) = dm(2)*m(6) + m(2)*dm(6)
    dm(19) = dm(1)*m(7) + m(1)*dm(7)
    dm(20) = dm(4)*m(5) + m(4)*dm(5)
    dm(21) = dm(4)*m(6) + m(4)*dm(6)
    dm(22) = dm(4)*m(7) + m(4)*dm(7)
    dm(23) = dm(2)*m(8) + m(2)*dm(8)
    dm(24) = dm(3)*m(8) + m(3)*dm(8)
    dm(25) = dm(1)*m(9) + m(1)*dm(9)
    dm(26) = dm(3)*m(9) + m(3)*dm(9)
    dm(27) = dm(1)*m(10) + m(1)*dm(10)
    dm(28) = dm(2)*m(10) + m(2)*dm(10)
    dm(29) = dm(7)*m(8) + m(7)*dm(8)
    dm(30) = dm(6)*m(9) + m(6)*dm(9)
    dm(31) = dm(5)*m(10) + m(5)*dm(10)
    dm(32) = dm(5)*m(6) + m(5)*dm(6)
    dm(33) = dm(5)*m(7) + m(5)*dm(7)
    dm(34) = dm(6)*m(7) + m(6)*dm(7)
    dm(35) = dm(5)*m(8) + m(5)*dm(8)
    dm(36) = dm(6)*m(8) + m(6)*dm(8)
    dm(37) = dm(5)*m(9) + m(5)*dm(9)
    dm(38) = dm(7)*m(9) + m(7)*dm(9)
    dm(39) = dm(8)*m(9) + m(8)*dm(9)
    dm(40) = dm(6)*m(10) + m(6)*dm(10)
    dm(41) = dm(7)*m(10) + m(7)*dm(10)
    dm(42) = dm(8)*m(10) + m(8)*dm(10)
    dm(43) = dm(9)*m(10) + m(9)*dm(10)
    dm(44) = dm(1)*m(13) + m(1)*dm(13)
    dm(45) = dm(1)*m(15) + m(1)*dm(15)
    dm(46) = dm(1)*m(16) + m(1)*dm(16)
    dm(47) = dm(2)*m(16) + m(2)*dm(16)
    dm(48) = dm(3)*m(20) + m(3)*dm(20)
    dm(49) = dm(2)*m(21) + m(2)*dm(21)
    dm(50) = dm(1)*m(22) + m(1)*dm(22)
    dm(51) = dm(2)*m(24) + m(2)*dm(24)
    dm(52) = dm(1)*m(26) + m(1)*dm(26)
    dm(53) = dm(1)*m(28) + m(1)*dm(28)
    dm(54) = dm(1)*m(17) + m(1)*dm(17)
    dm(55) = dm(2)*m(17) + m(2)*dm(17)
    dm(56) = dm(1)*m(18) + m(1)*dm(18)
    dm(57) = dm(3)*m(18) + m(3)*dm(18)
    dm(58) = dm(2)*m(19) + m(2)*dm(19)
    dm(59) = dm(3)*m(19) + m(3)*dm(19)
    dm(60) = dm(1)*m(20) + m(1)*dm(20)
    dm(61) = dm(2)*m(20) + m(2)*dm(20)
    dm(62) = dm(1)*m(21) + m(1)*dm(21)
    dm(63) = dm(3)*m(21) + m(3)*dm(21)
    dm(64) = dm(2)*m(22) + m(2)*dm(22)
    dm(65) = dm(3)*m(22) + m(3)*dm(22)
    dm(66) = dm(1)*m(23) + m(1)*dm(23)
    dm(67) = dm(1)*m(24) + m(1)*dm(24)
    dm(68) = dm(4)*m(23) + m(4)*dm(23)
    dm(69) = dm(4)*m(24) + m(4)*dm(24)
    dm(70) = dm(2)*m(25) + m(2)*dm(25)
    dm(71) = dm(2)*m(26) + m(2)*dm(26)
    dm(72) = dm(4)*m(25) + m(4)*dm(25)
    dm(73) = dm(4)*m(26) + m(4)*dm(26)
    dm(74) = dm(3)*m(27) + m(3)*dm(27)
    dm(75) = dm(3)*m(28) + m(3)*dm(28)
    dm(76) = dm(4)*m(27) + m(4)*dm(27)
    dm(77) = dm(4)*m(28) + m(4)*dm(28)
    dm(78) = dm(4)*m(32) + m(4)*dm(32)
    dm(79) = dm(4)*m(33) + m(4)*dm(33)
    dm(80) = dm(4)*m(34) + m(4)*dm(34)
    dm(81) = dm(3)*m(35) + m(3)*dm(35)
    dm(82) = dm(2)*m(36) + m(2)*dm(36)
    dm(83) = dm(3)*m(37) + m(3)*dm(37)
    dm(84) = dm(1)*m(38) + m(1)*dm(38)
    dm(85) = dm(3)*m(39) + m(3)*dm(39)
    dm(86) = dm(2)*m(40) + m(2)*dm(40)
    dm(87) = dm(1)*m(41) + m(1)*dm(41)
    dm(88) = dm(2)*m(42) + m(2)*dm(42)
    dm(89) = dm(1)*m(43) + m(1)*dm(43)
    dm(90) = dm(2)*m(32) + m(2)*dm(32)
    dm(91) = dm(3)*m(32) + m(3)*dm(32)
    dm(92) = dm(1)*m(33) + m(1)*dm(33)
    dm(93) = dm(3)*m(33) + m(3)*dm(33)
    dm(94) = dm(1)*m(34) + m(1)*dm(34)
    dm(95) = dm(2)*m(34) + m(2)*dm(34)
    dm(96) = dm(2)*m(35) + m(2)*dm(35)
    dm(97) = dm(3)*m(36) + m(3)*dm(36)
    dm(98) = dm(4)*m(35) + m(4)*dm(35)
    dm(99) = dm(4)*m(36) + m(4)*dm(36)
    dm(100) = dm(1)*m(37) + m(1)*dm(37)
    dm(101) = dm(3)*m(38) + m(3)*dm(38)
    dm(102) = dm(4)*m(37) + m(4)*dm(37)
    dm(103) = dm(4)*m(38) + m(4)*dm(38)
    dm(104) = dm(1)*m(39) + m(1)*dm(39)
    dm(105) = dm(2)*m(39) + m(2)*dm(39)
    dm(106) = dm(1)*m(40) + m(1)*dm(40)
    dm(107) = dm(2)*m(41) + m(2)*dm(41)
    dm(108) = dm(4)*m(40) + m(4)*dm(40)
    dm(109) = dm(4)*m(41) + m(4)*dm(41)
    dm(110) = dm(1)*m(42) + m(1)*dm(42)
    dm(111) = dm(3)*m(42) + m(3)*dm(42)
    dm(112) = dm(2)*m(43) + m(2)*dm(43)
    dm(113) = dm(3)*m(43) + m(3)*dm(43)
    dm(114) = dm(5)*m(29) + m(5)*dm(29)
    dm(115) = dm(6)*m(29) + m(6)*dm(29)
    dm(116) = dm(5)*m(30) + m(5)*dm(30)
    dm(117) = dm(6)*m(38) + m(6)*dm(38)
    dm(118) = dm(6)*m(39) + m(6)*dm(39)
    dm(119) = dm(7)*m(39) + m(7)*dm(39)
    dm(120) = dm(5)*m(40) + m(5)*dm(40)
    dm(121) = dm(5)*m(41) + m(5)*dm(41)
    dm(122) = dm(5)*m(42) + m(5)*dm(42)
    dm(123) = dm(7)*m(42) + m(7)*dm(42)
    dm(124) = dm(5)*m(43) + m(5)*dm(43)
    dm(125) = dm(6)*m(43) + m(6)*dm(43)
    dm(126) = dm(5)*m(34) + m(5)*dm(34)
    dm(127) = dm(5)*m(39) + m(5)*dm(39)
    dm(128) = dm(6)*m(42) + m(6)*dm(42)
    dm(129) = dm(7)*m(43) + m(7)*dm(43)
    dm(130) = dm(5)*m(36) + m(5)*dm(36)
    dm(131) = dm(5)*m(38) + m(5)*dm(38)
    dm(132) = dm(6)*m(41) + m(6)*dm(41)
    dm(133) = dm(8)*m(43) + m(8)*dm(43)
    dm(134) = dm(1)*m(47) + m(1)*dm(47)
    dm(135) = dm(1)*m(48) + m(1)*dm(48)
    dm(136) = dm(2)*m(48) + m(2)*dm(48)
    dm(137) = dm(1)*m(49) + m(1)*dm(49)
    dm(138) = dm(2)*m(63) + m(2)*dm(63)
    dm(139) = dm(1)*m(64) + m(1)*dm(64)
    dm(140) = dm(1)*m(65) + m(1)*dm(65)
    dm(141) = dm(1)*m(51) + m(1)*dm(51)
    dm(142) = dm(2)*m(69) + m(2)*dm(69)
    dm(143) = dm(1)*m(71) + m(1)*dm(71)
    dm(144) = dm(1)*m(73) + m(1)*dm(73)
    dm(145) = dm(1)*m(75) + m(1)*dm(75)
    dm(146) = dm(1)*m(77) + m(1)*dm(77)
    dm(147) = dm(7)*m(66) + m(7)*dm(66)
    dm(148) = dm(7)*m(67) + m(7)*dm(67)
    dm(149) = dm(7)*m(68) + m(7)*dm(68)
    dm(150) = dm(7)*m(69) + m(7)*dm(69)
    dm(151) = dm(6)*m(70) + m(6)*dm(70)
    dm(152) = dm(6)*m(71) + m(6)*dm(71)
    dm(153) = dm(6)*m(72) + m(6)*dm(72)
    dm(154) = dm(6)*m(73) + m(6)*dm(73)
    dm(155) = dm(5)*m(74) + m(5)*dm(74)
    dm(156) = dm(5)*m(75) + m(5)*dm(75)
    dm(157) = dm(5)*m(76) + m(5)*dm(76)
    dm(158) = dm(5)*m(77) + m(5)*dm(77)
    dm(159) = dm(2)*m(78) + m(2)*dm(78)
    dm(160) = dm(3)*m(78) + m(3)*dm(78)
    dm(161) = dm(1)*m(79) + m(1)*dm(79)
    dm(162) = dm(3)*m(79) + m(3)*dm(79)
    dm(163) = dm(1)*m(80) + m(1)*dm(80)
    dm(164) = dm(2)*m(80) + m(2)*dm(80)
    dm(165) = dm(2)*m(81) + m(2)*dm(81)
    dm(166) = dm(2)*m(97) + m(2)*dm(97)
    dm(167) = dm(3)*m(98) + m(3)*dm(98)
    dm(168) = dm(2)*m(99) + m(2)*dm(99)
    dm(169) = dm(1)*m(83) + m(1)*dm(83)
    dm(170) = dm(1)*m(101) + m(1)*dm(101)
    dm(171) = dm(3)*m(102) + m(3)*dm(102)
    dm(172) = dm(1)*m(103) + m(1)*dm(103)
    dm(173) = dm(1)*m(85) + m(1)*dm(85)
    dm(174) = dm(2)*m(85) + m(2)*dm(85)
    dm(175) = dm(1)*m(86) + m(1)*dm(86)
    dm(176) = dm(1)*m(107) + m(1)*dm(107)
    dm(177) = dm(2)*m(108) + m(2)*dm(108)
    dm(178) = dm(1)*m(109) + m(1)*dm(109)
    dm(179) = dm(1)*m(88) + m(1)*dm(88)
    dm(180) = dm(2)*m(111) + m(2)*dm(111)
    dm(181) = dm(1)*m(112) + m(1)*dm(112)
    dm(182) = dm(1)*m(113) + m(1)*dm(113)
    dm(183) = dm(2)*m(91) + m(2)*dm(91)
    dm(184) = dm(1)*m(93) + m(1)*dm(93)
    dm(185) = dm(1)*m(95) + m(1)*dm(95)
    dm(186) = dm(2)*m(98) + m(2)*dm(98)
    dm(187) = dm(3)*m(99) + m(3)*dm(99)
    dm(188) = dm(1)*m(102) + m(1)*dm(102)
    dm(189) = dm(3)*m(103) + m(3)*dm(103)
    dm(190) = dm(1)*m(105) + m(1)*dm(105)
    dm(191) = dm(1)*m(108) + m(1)*dm(108)
    dm(192) = dm(2)*m(109) + m(2)*dm(109)
    dm(193) = dm(1)*m(111) + m(1)*dm(111)
    dm(194) = dm(2)*m(113) + m(2)*dm(113)
    dm(195) = dm(3)*m(114) + m(3)*dm(114)
    dm(196) = dm(2)*m(115) + m(2)*dm(115)
    dm(197) = dm(4)*m(114) + m(4)*dm(114)
    dm(198) = dm(4)*m(115) + m(4)*dm(115)
    dm(199) = dm(3)*m(116) + m(3)*dm(116)
    dm(200) = dm(1)*m(117) + m(1)*dm(117)
    dm(201) = dm(4)*m(116) + m(4)*dm(116)
    dm(202) = dm(4)*m(117) + m(4)*dm(117)
    dm(203) = dm(2)*m(118) + m(2)*dm(118)
    dm(204) = dm(3)*m(118) + m(3)*dm(118)
    dm(205) = dm(1)*m(119) + m(1)*dm(119)
    dm(206) = dm(3)*m(119) + m(3)*dm(119)
    dm(207) = dm(2)*m(120) + m(2)*dm(120)
    dm(208) = dm(1)*m(121) + m(1)*dm(121)
    dm(209) = dm(4)*m(120) + m(4)*dm(120)
    dm(210) = dm(4)*m(121) + m(4)*dm(121)
    dm(211) = dm(2)*m(122) + m(2)*dm(122)
    dm(212) = dm(3)*m(122) + m(3)*dm(122)
    dm(213) = dm(1)*m(123) + m(1)*dm(123)
    dm(214) = dm(2)*m(123) + m(2)*dm(123)
    dm(215) = dm(1)*m(124) + m(1)*dm(124)
    dm(216) = dm(3)*m(124) + m(3)*dm(124)
    dm(217) = dm(1)*m(125) + m(1)*dm(125)
    dm(218) = dm(2)*m(125) + m(2)*dm(125)
    dm(219) = dm(6)*m(119) + m(6)*dm(119)
    dm(220) = dm(5)*m(123) + m(5)*dm(123)
    dm(221) = dm(5)*m(125) + m(5)*dm(125)
    dm(222) = dm(4)*m(126) + m(4)*dm(126)
    dm(223) = dm(3)*m(127) + m(3)*dm(127)
    dm(224) = dm(2)*m(128) + m(2)*dm(128)
    dm(225) = dm(1)*m(129) + m(1)*dm(129)
    dm(226) = dm(1)*m(78) + m(1)*dm(78)
    dm(227) = dm(2)*m(79) + m(2)*dm(79)
    dm(228) = dm(3)*m(80) + m(3)*dm(80)
    dm(229) = dm(1)*m(81) + m(1)*dm(81)
    dm(230) = dm(1)*m(82) + m(1)*dm(82)
    dm(231) = dm(2)*m(83) + m(2)*dm(83)
    dm(232) = dm(2)*m(84) + m(2)*dm(84)
    dm(233) = dm(4)*m(85) + m(4)*dm(85)
    dm(234) = dm(3)*m(86) + m(3)*dm(86)
    dm(235) = dm(3)*m(87) + m(3)*dm(87)
    dm(236) = dm(4)*m(88) + m(4)*dm(88)
    dm(237) = dm(4)*m(89) + m(4)*dm(89)
    dm(238) = dm(2)*m(130) + m(2)*dm(130)
    dm(239) = dm(3)*m(130) + m(3)*dm(130)
    dm(240) = dm(4)*m(130) + m(4)*dm(130)
    dm(241) = dm(1)*m(131) + m(1)*dm(131)
    dm(242) = dm(3)*m(131) + m(3)*dm(131)
    dm(243) = dm(4)*m(131) + m(4)*dm(131)
    dm(244) = dm(1)*m(132) + m(1)*dm(132)
    dm(245) = dm(2)*m(132) + m(2)*dm(132)
    dm(246) = dm(4)*m(132) + m(4)*dm(132)
    dm(247) = dm(1)*m(133) + m(1)*dm(133)
    dm(248) = dm(2)*m(133) + m(2)*dm(133)
    dm(249) = dm(3)*m(133) + m(3)*dm(133)
    dm(250) = dm(5)*m(115) + m(5)*dm(115)
    dm(251) = dm(5)*m(117) + m(5)*dm(117)
    dm(252) = dm(5)*m(118) + m(5)*dm(118)
    dm(253) = dm(5)*m(119) + m(5)*dm(119)
    dm(254) = dm(5)*m(132) + m(5)*dm(132)
    dm(255) = dm(5)*m(128) + m(5)*dm(128)
    dm(256) = dm(6)*m(123) + m(6)*dm(123)
    dm(257) = dm(5)*m(129) + m(5)*dm(129)
    dm(258) = dm(6)*m(129) + m(6)*dm(129)
    dm(259) = dm(5)*m(133) + m(5)*dm(133)
    dm(260) = dm(6)*m(133) + m(6)*dm(133)
    dm(261) = dm(7)*m(133) + m(7)*dm(133)
    dm(262) = dm(2)*m(160) + m(2)*dm(160)
    dm(263) = dm(1)*m(162) + m(1)*dm(162)
    dm(264) = dm(1)*m(164) + m(1)*dm(164)
    dm(265) = dm(2)*m(167) + m(2)*dm(167)
    dm(266) = dm(2)*m(187) + m(2)*dm(187)
    dm(267) = dm(1)*m(171) + m(1)*dm(171)
    dm(268) = dm(1)*m(189) + m(1)*dm(189)
    dm(269) = dm(1)*m(174) + m(1)*dm(174)
    dm(270) = dm(1)*m(177) + m(1)*dm(177)
    dm(271) = dm(1)*m(192) + m(1)*dm(192)
    dm(272) = dm(1)*m(180) + m(1)*dm(180)
    dm(273) = dm(1)*m(194) + m(1)*dm(194)
    dm(274) = dm(3)*m(197) + m(3)*dm(197)
    dm(275) = dm(2)*m(198) + m(2)*dm(198)
    dm(276) = dm(3)*m(201) + m(3)*dm(201)
    dm(277) = dm(1)*m(202) + m(1)*dm(202)
    dm(278) = dm(2)*m(204) + m(2)*dm(204)
    dm(279) = dm(1)*m(206) + m(1)*dm(206)
    dm(280) = dm(2)*m(209) + m(2)*dm(209)
    dm(281) = dm(1)*m(210) + m(1)*dm(210)
    dm(282) = dm(2)*m(212) + m(2)*dm(212)
    dm(283) = dm(1)*m(214) + m(1)*dm(214)
    dm(284) = dm(1)*m(216) + m(1)*dm(216)
    dm(285) = dm(1)*m(218) + m(1)*dm(218)
    dm(286) = dm(1)*m(159) + m(1)*dm(159)
    dm(287) = dm(1)*m(160) + m(1)*dm(160)
    dm(288) = dm(1)*m(227) + m(1)*dm(227)
    dm(289) = dm(2)*m(162) + m(2)*dm(162)
    dm(290) = dm(1)*m(228) + m(1)*dm(228)
    dm(291) = dm(2)*m(228) + m(2)*dm(228)
    dm(292) = dm(1)*m(165) + m(1)*dm(165)
    dm(293) = dm(1)*m(166) + m(1)*dm(166)
    dm(294) = dm(1)*m(167) + m(1)*dm(167)
    dm(295) = dm(1)*m(168) + m(1)*dm(168)
    dm(296) = dm(1)*m(231) + m(1)*dm(231)
    dm(297) = dm(2)*m(170) + m(2)*dm(170)
    dm(298) = dm(2)*m(171) + m(2)*dm(171)
    dm(299) = dm(2)*m(172) + m(2)*dm(172)
    dm(300) = dm(1)*m(233) + m(1)*dm(233)
    dm(301) = dm(2)*m(233) + m(2)*dm(233)
    dm(302) = dm(1)*m(234) + m(1)*dm(234)
    dm(303) = dm(2)*m(235) + m(2)*dm(235)
    dm(304) = dm(3)*m(177) + m(3)*dm(177)
    dm(305) = dm(3)*m(178) + m(3)*dm(178)
    dm(306) = dm(1)*m(236) + m(1)*dm(236)
    dm(307) = dm(3)*m(236) + m(3)*dm(236)
    dm(308) = dm(2)*m(237) + m(2)*dm(237)
    dm(309) = dm(3)*m(237) + m(3)*dm(237)
    dm(310) = dm(1)*m(195) + m(1)*dm(195)
    dm(311) = dm(1)*m(196) + m(1)*dm(196)
    dm(312) = dm(2)*m(197) + m(2)*dm(197)
    dm(313) = dm(3)*m(198) + m(3)*dm(198)
    dm(314) = dm(2)*m(199) + m(2)*dm(199)
    dm(315) = dm(2)*m(200) + m(2)*dm(200)
    dm(316) = dm(1)*m(201) + m(1)*dm(201)
    dm(317) = dm(3)*m(202) + m(3)*dm(202)
    dm(318) = dm(1)*m(203) + m(1)*dm(203)
    dm(319) = dm(2)*m(205) + m(2)*dm(205)
    dm(320) = dm(4)*m(204) + m(4)*dm(204)
    dm(321) = dm(4)*m(206) + m(4)*dm(206)
    dm(322) = dm(3)*m(207) + m(3)*dm(207)
    dm(323) = dm(3)*m(208) + m(3)*dm(208)
    dm(324) = dm(1)*m(209) + m(1)*dm(209)
    dm(325) = dm(2)*m(210) + m(2)*dm(210)
    dm(326) = dm(1)*m(212) + m(1)*dm(212)
    dm(327) = dm(3)*m(213) + m(3)*dm(213)
    dm(328) = dm(4)*m(211) + m(4)*dm(211)
    dm(329) = dm(4)*m(214) + m(4)*dm(214)
    dm(330) = dm(2)*m(216) + m(2)*dm(216)
    dm(331) = dm(3)*m(218) + m(3)*dm(218)
    dm(332) = dm(4)*m(215) + m(4)*dm(215)
    dm(333) = dm(4)*m(217) + m(4)*dm(217)
    dm(334) = dm(2)*m(195) + m(2)*dm(195)
    dm(335) = dm(3)*m(196) + m(3)*dm(196)
    dm(336) = dm(1)*m(197) + m(1)*dm(197)
    dm(337) = dm(1)*m(198) + m(1)*dm(198)
    dm(338) = dm(1)*m(199) + m(1)*dm(199)
    dm(339) = dm(3)*m(200) + m(3)*dm(200)
    dm(340) = dm(2)*m(201) + m(2)*dm(201)
    dm(341) = dm(2)*m(202) + m(2)*dm(202)
    dm(342) = dm(1)*m(204) + m(1)*dm(204)
    dm(343) = dm(2)*m(206) + m(2)*dm(206)
    dm(344) = dm(4)*m(203) + m(4)*dm(203)
    dm(345) = dm(4)*m(205) + m(4)*dm(205)
    dm(346) = dm(1)*m(207) + m(1)*dm(207)
    dm(347) = dm(2)*m(208) + m(2)*dm(208)
    dm(348) = dm(3)*m(209) + m(3)*dm(209)
    dm(349) = dm(3)*m(210) + m(3)*dm(210)
    dm(350) = dm(1)*m(211) + m(1)*dm(211)
    dm(351) = dm(3)*m(214) + m(3)*dm(214)
    dm(352) = dm(4)*m(212) + m(4)*dm(212)
    dm(353) = dm(4)*m(213) + m(4)*dm(213)
    dm(354) = dm(2)*m(215) + m(2)*dm(215)
    dm(355) = dm(3)*m(217) + m(3)*dm(217)
    dm(356) = dm(4)*m(216) + m(4)*dm(216)
    dm(357) = dm(4)*m(218) + m(4)*dm(218)
    dm(358) = dm(1)*m(222) + m(1)*dm(222)
    dm(359) = dm(2)*m(222) + m(2)*dm(222)
    dm(360) = dm(3)*m(222) + m(3)*dm(222)
    dm(361) = dm(1)*m(223) + m(1)*dm(223)
    dm(362) = dm(2)*m(223) + m(2)*dm(223)
    dm(363) = dm(4)*m(223) + m(4)*dm(223)
    dm(364) = dm(1)*m(224) + m(1)*dm(224)
    dm(365) = dm(3)*m(224) + m(3)*dm(224)
    dm(366) = dm(4)*m(224) + m(4)*dm(224)
    dm(367) = dm(2)*m(225) + m(2)*dm(225)
    dm(368) = dm(3)*m(225) + m(3)*dm(225)
    dm(369) = dm(4)*m(225) + m(4)*dm(225)
    dm(370) = dm(2)*m(239) + m(2)*dm(239)
    dm(371) = dm(2)*m(240) + m(2)*dm(240)
    dm(372) = dm(3)*m(240) + m(3)*dm(240)
    dm(373) = dm(1)*m(242) + m(1)*dm(242)
    dm(374) = dm(1)*m(243) + m(1)*dm(243)
    dm(375) = dm(3)*m(243) + m(3)*dm(243)
    dm(376) = dm(1)*m(245) + m(1)*dm(245)
    dm(377) = dm(1)*m(246) + m(1)*dm(246)
    dm(378) = dm(2)*m(246) + m(2)*dm(246)
    dm(379) = dm(1)*m(248) + m(1)*dm(248)
    dm(380) = dm(1)*m(249) + m(1)*dm(249)
    dm(381) = dm(2)*m(249) + m(2)*dm(249)
    dm(382) = dm(4)*m(250) + m(4)*dm(250)
    dm(383) = dm(4)*m(251) + m(4)*dm(251)
    dm(384) = dm(3)*m(252) + m(3)*dm(252)
    dm(385) = dm(3)*m(253) + m(3)*dm(253)
    dm(386) = dm(4)*m(254) + m(4)*dm(254)
    dm(387) = dm(2)*m(255) + m(2)*dm(255)
    dm(388) = dm(2)*m(256) + m(2)*dm(256)
    dm(389) = dm(1)*m(257) + m(1)*dm(257)
    dm(390) = dm(1)*m(258) + m(1)*dm(258)
    dm(391) = dm(3)*m(259) + m(3)*dm(259)
    dm(392) = dm(2)*m(260) + m(2)*dm(260)
    dm(393) = dm(1)*m(261) + m(1)*dm(261)
    dm(394) = dm(2)*m(250) + m(2)*dm(250)
    dm(395) = dm(3)*m(250) + m(3)*dm(250)
    dm(396) = dm(1)*m(251) + m(1)*dm(251)
    dm(397) = dm(3)*m(251) + m(3)*dm(251)
    dm(398) = dm(2)*m(252) + m(2)*dm(252)
    dm(399) = dm(1)*m(253) + m(1)*dm(253)
    dm(400) = dm(4)*m(252) + m(4)*dm(252)
    dm(401) = dm(4)*m(253) + m(4)*dm(253)
    dm(402) = dm(1)*m(254) + m(1)*dm(254)
    dm(403) = dm(2)*m(254) + m(2)*dm(254)
    dm(404) = dm(3)*m(255) + m(3)*dm(255)
    dm(405) = dm(1)*m(256) + m(1)*dm(256)
    dm(406) = dm(4)*m(255) + m(4)*dm(255)
    dm(407) = dm(4)*m(256) + m(4)*dm(256)
    dm(408) = dm(3)*m(257) + m(3)*dm(257)
    dm(409) = dm(2)*m(258) + m(2)*dm(258)
    dm(410) = dm(4)*m(257) + m(4)*dm(257)
    dm(411) = dm(4)*m(258) + m(4)*dm(258)
    dm(412) = dm(1)*m(259) + m(1)*dm(259)
    dm(413) = dm(2)*m(259) + m(2)*dm(259)
    dm(414) = dm(1)*m(260) + m(1)*dm(260)
    dm(415) = dm(3)*m(260) + m(3)*dm(260)
    dm(416) = dm(2)*m(261) + m(2)*dm(261)
    dm(417) = dm(3)*m(261) + m(3)*dm(261)
    dm(418) = dm(5)*m(219) + m(5)*dm(219)
    dm(419) = dm(5)*m(256) + m(5)*dm(256)
    dm(420) = dm(5)*m(258) + m(5)*dm(258)
    dm(421) = dm(5)*m(260) + m(5)*dm(260)
    dm(422) = dm(5)*m(261) + m(5)*dm(261)
    dm(423) = dm(6)*m(261) + m(6)*dm(261)
    dm(424) = dm(3)*m(135) + m(3)*dm(135)
    dm(425) = dm(3)*m(136) + m(3)*dm(136)
    dm(426) = dm(2)*m(137) + m(2)*dm(137)
    dm(427) = dm(2)*m(138) + m(2)*dm(138)
    dm(428) = dm(1)*m(139) + m(1)*dm(139)
    dm(429) = dm(1)*m(140) + m(1)*dm(140)
    dm(430) = dm(4)*m(135) + m(4)*dm(135)
    dm(431) = dm(4)*m(136) + m(4)*dm(136)
    dm(432) = dm(4)*m(137) + m(4)*dm(137)
    dm(433) = dm(4)*m(138) + m(4)*dm(138)
    dm(434) = dm(4)*m(139) + m(4)*dm(139)
    dm(435) = dm(4)*m(140) + m(4)*dm(140)
    dm(436) = dm(2)*m(141) + m(2)*dm(141)
    dm(437) = dm(3)*m(141) + m(3)*dm(141)
    dm(438) = dm(2)*m(142) + m(2)*dm(142)
    dm(439) = dm(3)*m(142) + m(3)*dm(142)
    dm(440) = dm(1)*m(143) + m(1)*dm(143)
    dm(441) = dm(3)*m(143) + m(3)*dm(143)
    dm(442) = dm(1)*m(144) + m(1)*dm(144)
    dm(443) = dm(3)*m(144) + m(3)*dm(144)
    dm(444) = dm(1)*m(145) + m(1)*dm(145)
    dm(445) = dm(2)*m(145) + m(2)*dm(145)
    dm(446) = dm(1)*m(146) + m(1)*dm(146)
    dm(447) = dm(2)*m(146) + m(2)*dm(146)
    dm(448) = dm(4)*m(159) + m(4)*dm(159)
    dm(449) = dm(4)*m(160) + m(4)*dm(160)
    dm(450) = dm(4)*m(161) + m(4)*dm(161)
    dm(451) = dm(4)*m(162) + m(4)*dm(162)
    dm(452) = dm(4)*m(163) + m(4)*dm(163)
    dm(453) = dm(4)*m(164) + m(4)*dm(164)
    dm(454) = dm(3)*m(165) + m(3)*dm(165)
    dm(455) = dm(2)*m(166) + m(2)*dm(166)
    dm(456) = dm(3)*m(167) + m(3)*dm(167)
    dm(457) = dm(2)*m(168) + m(2)*dm(168)
    dm(458) = dm(3)*m(169) + m(3)*dm(169)
    dm(459) = dm(1)*m(170) + m(1)*dm(170)
    dm(460) = dm(3)*m(171) + m(3)*dm(171)
    dm(461) = dm(1)*m(172) + m(1)*dm(172)
    dm(462) = dm(3)*m(173) + m(3)*dm(173)
    dm(463) = dm(3)*m(174) + m(3)*dm(174)
    dm(464) = dm(2)*m(175) + m(2)*dm(175)
    dm(465) = dm(1)*m(176) + m(1)*dm(176)
    dm(466) = dm(2)*m(177) + m(2)*dm(177)
    dm(467) = dm(1)*m(178) + m(1)*dm(178)
    dm(468) = dm(2)*m(179) + m(2)*dm(179)
    dm(469) = dm(2)*m(180) + m(2)*dm(180)
    dm(470) = dm(1)*m(181) + m(1)*dm(181)
    dm(471) = dm(1)*m(182) + m(1)*dm(182)
    dm(472) = dm(19)*m(114) + m(19)*dm(114)
    dm(473) = dm(19)*m(115) + m(19)*dm(115)
    dm(474) = dm(23)*m(114) + m(23)*dm(114)
    dm(475) = dm(24)*m(115) + m(24)*dm(115)
    dm(476) = dm(18)*m(116) + m(18)*dm(116)
    dm(477) = dm(18)*m(117) + m(18)*dm(117)
    dm(478) = dm(21)*m(118) + m(21)*dm(118)
    dm(479) = dm(22)*m(119) + m(22)*dm(119)
    dm(480) = dm(23)*m(119) + m(23)*dm(119)
    dm(481) = dm(25)*m(116) + m(25)*dm(116)
    dm(482) = dm(26)*m(117) + m(26)*dm(117)
    dm(483) = dm(25)*m(118) + m(25)*dm(118)
    dm(484) = dm(17)*m(120) + m(17)*dm(120)
    dm(485) = dm(17)*m(121) + m(17)*dm(121)
    dm(486) = dm(20)*m(122) + m(20)*dm(122)
    dm(487) = dm(22)*m(123) + m(22)*dm(123)
    dm(488) = dm(24)*m(123) + m(24)*dm(123)
    dm(489) = dm(20)*m(124) + m(20)*dm(124)
    dm(490) = dm(21)*m(125) + m(21)*dm(125)
    dm(491) = dm(26)*m(125) + m(26)*dm(125)
    dm(492) = dm(27)*m(120) + m(27)*dm(120)
    dm(493) = dm(28)*m(121) + m(28)*dm(121)
    dm(494) = dm(27)*m(122) + m(27)*dm(122)
    dm(495) = dm(28)*m(124) + m(28)*dm(124)

    return
  end subroutine devmono

  subroutine devpoly(dm,p,dp)
    implicit none
    real,dimension(0:495),intent(in)::dm
    real,dimension(0:207),intent(in)::p
    real,dimension(0:207),intent(out)::dp
    !::::::::::::::::::::

    dp(0) = dm(0)
    dp(1) = dm(1) + dm(2) + dm(3) + dm(4)
    dp(2) = dm(5) + dm(6) + dm(7) + dm(8) + dm(9) + dm(10)
    dp(3) = dm(11) + dm(12) + dm(13) + dm(14) + dm(15) + dm(16)
    dp(4) = dm(17) + dm(18) + dm(19) + dm(20) + dm(21) + dm(22) &
	&  + dm(23) + dm(24) + dm(25) + dm(26) + dm(27) &
	&  + dm(28)
    dp(5) = dm(29) + dm(30) + dm(31)
    dp(6) = dp(1)*p(2) + p(1)*dp(2) - dp(4)
    dp(7) = dm(32) + dm(33) + dm(34) + dm(35) + dm(36) + dm(37) &
	&  + dm(38) + dm(39) + dm(40) + dm(41) + dm(42) &
	&  + dm(43)
    dp(8) = dp(1)*p(1) + p(1)*dp(1) - dp(3) - dp(3)
    dp(9) = dp(2)*p(2) + p(2)*dp(2) - dp(7) - dp(5) - dp(7) - dp(5)
    dp(10) = dm(44) + dm(45) + dm(46) + dm(47)
    dp(11) = dm(48) + dm(49) + dm(50) + dm(51) + dm(52) + dm(53)
    dp(12) = dm(54) + dm(55) + dm(56) + dm(57) + dm(58) + dm(59) &
	&  + dm(60) + dm(61) + dm(62) + dm(63) + dm(64) &
	&  + dm(65) + dm(66) + dm(67) + dm(68) + dm(69) &
	&  + dm(70) + dm(71) + dm(72) + dm(73) + dm(74) &
	&  + dm(75) + dm(76) + dm(77)
    dp(13) = dp(1)*p(5) + p(1)*dp(5)
    dp(14) = dp(2)*p(3) + p(2)*dp(3) - dp(12) - dp(11)
    dp(15) = dm(78) + dm(79) + dm(80) + dm(81) + dm(82) + dm(83) &
	&  + dm(84) + dm(85) + dm(86) + dm(87) + dm(88) &
	&  + dm(89)
    dp(16) = dm(90) + dm(91) + dm(92) + dm(93) + dm(94) + dm(95) &
	&  + dm(96) + dm(97) + dm(98) + dm(99) + dm(100) &
	&  + dm(101) + dm(102) + dm(103) + dm(104) + dm(105) &
	&  + dm(106) + dm(107) + dm(108) + dm(109) + dm(110) &
	&  + dm(111) + dm(112) + dm(113)
    dp(17) = dm(114) + dm(115) + dm(116) + dm(117) + dm(118) + dm(119) &
	&  + dm(120) + dm(121) + dm(122) + dm(123) + dm(124) &
	&  + dm(125)
    dp(18) = dm(126) + dm(127) + dm(128) + dm(129)
    dp(19) = dp(1)*p(7) + p(1)*dp(7) - dp(16) - dp(15)
    dp(20) = dm(130) + dm(131) + dm(132) + dm(133)
    dp(21) = dp(1)*p(3) + p(1)*dp(3) - dp(10) - dp(10) - dp(10)
    dp(22) = dp(1)*p(4) + p(1)*dp(4) - dp(12) - dp(11) - dp(11)
    dp(23) = dp(2)*p(8) + p(2)*dp(8) - dp(22)
    dp(24) = dp(2)*p(4) + p(2)*dp(4) - dp(16) - dp(15) - dp(13) - dp(15)
    dp(25) = dp(2)*p(5) + p(2)*dp(5) - dp(17)
    dp(26) = dp(1)*p(9) + p(1)*dp(9) - dp(24)
    dp(27) = dp(2)*p(7) + p(2)*dp(7) - dp(18) - dp(20) - dp(17) - dp(18) - dp(20) - dp(17) &
	&  - dp(18) - dp(20)
    dp(28) = dp(1)*p(8) + p(1)*dp(8) - dp(21)
    dp(29) = dp(2)*p(9) + p(2)*dp(9) - dp(27) - dp(25)
    dp(30) = dm(134)
    dp(31) = dm(135) + dm(136) + dm(137) + dm(138) + dm(139) + dm(140) &
	&  + dm(141) + dm(142) + dm(143) + dm(144) + dm(145) &
	&  + dm(146)
    dp(32) = dm(147) + dm(148) + dm(149) + dm(150) + dm(151) + dm(152) &
	&  + dm(153) + dm(154) + dm(155) + dm(156) + dm(157) &
	&  + dm(158)
    dp(33) = dp(2)*p(10) + p(2)*dp(10) - dp(31)
    dp(34) = dp(3)*p(5) + p(3)*dp(5) - dp(32)
    dp(35) = dm(159) + dm(160) + dm(161) + dm(162) + dm(163) + dm(164) &
	&  + dm(165) + dm(166) + dm(167) + dm(168) + dm(169) &
	&  + dm(170) + dm(171) + dm(172) + dm(173) + dm(174) &
	&  + dm(175) + dm(176) + dm(177) + dm(178) + dm(179) &
	&  + dm(180) + dm(181) + dm(182)
    dp(36) = dm(183) + dm(184) + dm(185) + dm(186) + dm(187) + dm(188) &
	&  + dm(189) + dm(190) + dm(191) + dm(192) + dm(193) &
	&  + dm(194)
    dp(37) = dm(195) + dm(196) + dm(197) + dm(198) + dm(199) + dm(200) &
	&  + dm(201) + dm(202) + dm(203) + dm(204) + dm(205) &
	&  + dm(206) + dm(207) + dm(208) + dm(209) + dm(210) &
	&  + dm(211) + dm(212) + dm(213) + dm(214) + dm(215) &
	&  + dm(216) + dm(217) + dm(218)
    dp(38) = dm(219) + dm(220) + dm(221)
    dp(39) = dm(222) + dm(223) + dm(224) + dm(225)
    dp(40) = dm(226) + dm(227) + dm(228) + dm(229) + dm(230) + dm(231) &
	&  + dm(232) + dm(233) + dm(234) + dm(235) + dm(236) &
	&  + dm(237)
    dp(41) = dp(3)*p(7) + p(3)*dp(7) - dp(36) - dp(40) - dp(35)
    dp(42) = dp(1)*p(17) + p(1)*dp(17) - dp(37)
    dp(43) = dp(1)*p(18) + p(1)*dp(18) - dp(39)
    dp(44) = dm(238) + dm(239) + dm(240) + dm(241) + dm(242) + dm(243) &
	&  + dm(244) + dm(245) + dm(246) + dm(247) + dm(248) &
	&  + dm(249)
    dp(45) = dm(250) + dm(251) + dm(252) + dm(253) + dm(254) + dm(255) &
	&  + dm(256) + dm(257) + dm(258) + dm(259) + dm(260) &
	&  + dm(261)
    dp(46) = dp(1)*p(20) + p(1)*dp(20) - dp(44)
    dp(47) = dp(1)*p(10) + p(1)*dp(10) - dp(30) - dp(30) - dp(30) - dp(30)
    dp(48) = dp(1)*p(11) + p(1)*dp(11) - dp(31)
    dp(49) = dp(3)*p(4) + p(3)*dp(4) - dp(33) - dp(31) - dp(48) - dp(31)
    dp(50) = dp(1)*p(12) + p(1)*dp(12) - dp(33) - dp(31) - dp(49) - dp(33) - dp(31)
    dp(51) = dp(5)*p(8) + p(5)*dp(8)
    dp(52) = dp(1)*p(14) + p(1)*dp(14) - dp(33)
    dp(53) = dp(1)*p(15) + p(1)*dp(15) - dp(40) - dp(35)
    dp(54) = dp(1)*p(16) + p(1)*dp(16) - dp(41) - dp(36) - dp(35) - dp(36)
    dp(55) = dp(1)*p(19) + p(1)*dp(19) - dp(41) - dp(40)
    dp(56) = dp(2)*p(11) + p(2)*dp(11) - dp(35) - dp(34)
    dp(57) = dp(4)*p(5) + p(4)*dp(5) - dp(37)
    dp(58) = dp(2)*p(12) + p(2)*dp(12) - dp(41) - dp(36) - dp(40) - dp(35) - dp(32) - dp(36) &
	&  - dp(40) - dp(32)
    dp(59) = dp(1)*p(25) + p(1)*dp(25) - dp(57)
    dp(60) = dp(2)*p(14) + p(2)*dp(14) - dp(41) - dp(34)
    dp(61) = dp(2)*p(15) + p(2)*dp(15) - dp(39) - dp(44) - dp(37) - dp(39) - dp(39)
    dp(62) = dp(4)*p(7) + p(4)*dp(7) - dp(43) - dp(39) - dp(44) - dp(42) - dp(37) - dp(61) &
	&  - dp(39) - dp(44) - dp(39)
    dp(63) = dp(5)*p(7) + p(5)*dp(7) - dp(45)
    dp(64) = dp(2)*p(16) + p(2)*dp(16) - dp(43) - dp(44) - dp(42) - dp(37) - dp(62) - dp(43) &
	&  - dp(44)
    dp(65) = dp(2)*p(17) + p(2)*dp(17) - dp(45) - dp(38) - dp(63) - dp(45) - dp(38) - dp(38) &
	&  - dp(38)
    dp(66) = dp(2)*p(18) + p(2)*dp(18) - dp(45)
    dp(67) = dp(1)*p(27) + p(1)*dp(27) - dp(64) - dp(62) - dp(61)
    dp(68) = dp(2)*p(20) + p(2)*dp(20) - dp(45)
    dp(69) = dp(3)*p(3) + p(3)*dp(3) - dp(30) - dp(47) - dp(30) - dp(47) - dp(30) - dp(30) &
	&  - dp(30) - dp(30)
    dp(70) = dp(3)*p(8) + p(3)*dp(8) - dp(47)
    dp(71) = dp(1)*p(22) + p(1)*dp(22) - dp(49) - dp(48)
    dp(72) = dp(2)*p(28) + p(2)*dp(28) - dp(71)
    dp(73) = dp(1)*p(24) + p(1)*dp(24) - dp(58) - dp(56) - dp(56)
    dp(74) = dp(5)*p(5) + p(5)*dp(5) - dp(38) - dp(38)
    dp(75) = dp(8)*p(9) + p(8)*dp(9) - dp(73)
    dp(76) = dp(7)*p(7) + p(7)*dp(7) - dp(45) - dp(38) - dp(66) - dp(68) - dp(65) - dp(45) &
	&  - dp(38) - dp(66) - dp(68) - dp(65) - dp(45) &
	&  - dp(38) - dp(45) - dp(38)
    dp(77) = dp(2)*p(24) + p(2)*dp(24) - dp(62) - dp(61) - dp(57)
    dp(78) = dp(5)*p(9) + p(5)*dp(9) - dp(65)
    dp(79) = dp(1)*p(29) + p(1)*dp(29) - dp(77)
    dp(80) = dp(7)*p(9) + p(7)*dp(9) - dp(66) - dp(68) - dp(63)
    dp(81) = dp(1)*p(28) + p(1)*dp(28) - dp(70)
    dp(82) = dp(2)*p(29) + p(2)*dp(29) - dp(80) - dp(78)
    dp(83) = dp(30)*p(2) + p(30)*dp(2)
    dp(84) = dp(5)*p(10) + p(5)*dp(10)
    dp(85) = dm(262) + dm(263) + dm(264) + dm(265) + dm(266) + dm(267) &
	&  + dm(268) + dm(269) + dm(270) + dm(271) + dm(272) &
	&  + dm(273)
    dp(86) = dm(274) + dm(275) + dm(276) + dm(277) + dm(278) + dm(279) &
	&  + dm(280) + dm(281) + dm(282) + dm(283) + dm(284) &
	&  + dm(285)
    dp(87) = dm(286) + dm(287) + dm(288) + dm(289) + dm(290) + dm(291) &
	&  + dm(292) + dm(293) + dm(294) + dm(295) + dm(296) &
	&  + dm(297) + dm(298) + dm(299) + dm(300) + dm(301) &
	&  + dm(302) + dm(303) + dm(304) + dm(305) + dm(306) &
	&  + dm(307) + dm(308) + dm(309)
    dp(88) = dp(7)*p(10) + p(7)*dp(10) - dp(87) - dp(85)
    dp(89) = dm(310) + dm(311) + dm(312) + dm(313) + dm(314) + dm(315) &
	&  + dm(316) + dm(317) + dm(318) + dm(319) + dm(320) &
	&  + dm(321) + dm(322) + dm(323) + dm(324) + dm(325) &
	&  + dm(326) + dm(327) + dm(328) + dm(329) + dm(330) &
	&  + dm(331) + dm(332) + dm(333)
    dp(90) = dm(334) + dm(335) + dm(336) + dm(337) + dm(338) + dm(339) &
	&  + dm(340) + dm(341) + dm(342) + dm(343) + dm(344) &
	&  + dm(345) + dm(346) + dm(347) + dm(348) + dm(349) &
	&  + dm(350) + dm(351) + dm(352) + dm(353) + dm(354) &
	&  + dm(355) + dm(356) + dm(357)
    dp(91) = dp(1)*p(38) + p(1)*dp(38)
    dp(92) = dp(3)*p(17) + p(3)*dp(17) - dp(89) - dp(90) - dp(86)
    dp(93) = dm(358) + dm(359) + dm(360) + dm(361) + dm(362) + dm(363) &
	&  + dm(364) + dm(365) + dm(366) + dm(367) + dm(368) &
	&  + dm(369)
    dp(94) = dp(3)*p(18) + p(3)*dp(18) - dp(93)
    dp(95) = dm(370) + dm(371) + dm(372) + dm(373) + dm(374) + dm(375) &
	&  + dm(376) + dm(377) + dm(378) + dm(379) + dm(380) &
	&  + dm(381)
    dp(96) = dm(382) + dm(383) + dm(384) + dm(385) + dm(386) + dm(387) &
	&  + dm(388) + dm(389) + dm(390) + dm(391) + dm(392) &
	&  + dm(393)
    dp(97) = dm(394) + dm(395) + dm(396) + dm(397) + dm(398) + dm(399) &
	&  + dm(400) + dm(401) + dm(402) + dm(403) + dm(404) &
	&  + dm(405) + dm(406) + dm(407) + dm(408) + dm(409) &
	&  + dm(410) + dm(411) + dm(412) + dm(413) + dm(414) &
	&  + dm(415) + dm(416) + dm(417)
    dp(98) = dm(418) + dm(419) + dm(420) + dm(421) + dm(422) + dm(423)
    dp(99) = dp(3)*p(20) + p(3)*dp(20) - dp(95)
    dp(100) = dp(1)*p(45) + p(1)*dp(45) - dp(97) - dp(96)
    dp(101) = dp(30)*p(1) + p(30)*dp(1)
    dp(102) = dm(424) + dm(425) + dm(426) + dm(427) + dm(428) + dm(429) &
	&  + dm(430) + dm(431) + dm(432) + dm(433) + dm(434) &
	&  + dm(435) + dm(436) + dm(437) + dm(438) + dm(439) &
	&  + dm(440) + dm(441) + dm(442) + dm(443) + dm(444) &
	&  + dm(445) + dm(446) + dm(447)
    dp(103) = dp(4)*p(10) + p(4)*dp(10) - dp(83) - dp(102) - dp(83)
    dp(104) = dp(1)*p(31) + p(1)*dp(31) - dp(83) - dp(102) - dp(83)
    dp(105) = dp(1)*p(32) + p(1)*dp(32) - dp(84) - dp(84)
    dp(106) = dp(1)*p(33) + p(1)*dp(33) - dp(83) - dp(103) - dp(83)
    dp(107) = dp(1)*p(34) + p(1)*dp(34) - dp(84)
    dp(108) = dm(448) + dm(449) + dm(450) + dm(451) + dm(452) + dm(453) &
	&  + dm(454) + dm(455) + dm(456) + dm(457) + dm(458) &
	&  + dm(459) + dm(460) + dm(461) + dm(462) + dm(463) &
	&  + dm(464) + dm(465) + dm(466) + dm(467) + dm(468) &
	&  + dm(469) + dm(470) + dm(471)
    dp(109) = dp(1)*p(35) + p(1)*dp(35) - dp(87) - dp(85) - dp(108) - dp(85)
    dp(110) = dp(1)*p(36) + p(1)*dp(36) - dp(88) - dp(85)
    dp(111) = dp(1)*p(37) + p(1)*dp(37) - dp(89) - dp(90) - dp(86) - dp(86)
    dp(112) = dp(1)*p(39) + p(1)*dp(39) - dp(93)
    dp(113) = dp(3)*p(15) + p(3)*dp(15) - dp(87) - dp(85) - dp(108)
    dp(114) = dp(3)*p(16) + p(3)*dp(16) - dp(88) - dp(87) - dp(85) - dp(110) - dp(109) - dp(88) &
	&  - dp(85)
    dp(115) = dp(1)*p(40) + p(1)*dp(40) - dp(87) - dp(113)
    dp(116) = dp(3)*p(19) + p(3)*dp(19) - dp(88) - dp(87) - dp(115)
    dp(117) = dp(8)*p(17) + p(8)*dp(17) - dp(111)
    dp(118) = dp(8)*p(18) + p(8)*dp(18) - dp(112)
    dp(119) = dp(1)*p(44) + p(1)*dp(44) - dp(99) - dp(95) - dp(95)
    dp(120) = dp(1)*p(46) + p(1)*dp(46) - dp(99)
    dp(121) = dp(5)*p(11) + p(5)*dp(11) - dp(86)
    dp(122) = dp(6)*p(11) + p(6)*dp(11) - dp(87) - dp(109) - dp(107)
    dp(123) = dp(5)*p(12) + p(5)*dp(12) - dp(89) - dp(90)
    dp(124) = dp(9)*p(10) + p(9)*dp(10) - dp(122)
    dp(125) = dp(5)*p(14) + p(5)*dp(14) - dp(92)
    dp(126) = dp(7)*p(11) + p(7)*dp(11) - dp(93) - dp(95) - dp(90)
    dp(127) = dp(5)*p(15) + p(5)*dp(15) - dp(96)
    dp(128) = dm(472) + dm(473) + dm(474) + dm(475) + dm(476) + dm(477) &
	&  + dm(478) + dm(479) + dm(480) + dm(481) + dm(482) &
	&  + dm(483) + dm(484) + dm(485) + dm(486) + dm(487) &
	&  + dm(488) + dm(489) + dm(490) + dm(491) + dm(492) &
	&  + dm(493) + dm(494) + dm(495)
    dp(129) = dp(2)*p(35) + p(2)*dp(35) - dp(93) - dp(95) - dp(90) - dp(86) - dp(126) - dp(93) &
	&  - dp(95) - dp(86)
    dp(130) = dp(2)*p(36) + p(2)*dp(36) - dp(94) - dp(95) - dp(89)
    dp(131) = dp(5)*p(16) + p(5)*dp(16) - dp(97) - dp(128)
    dp(132) = dp(2)*p(37) + p(2)*dp(37) - dp(97) - dp(96) - dp(91) - dp(131) - dp(127) - dp(96) &
	&  - dp(91)
    dp(133) = dp(2)*p(38) + p(2)*dp(38) - dp(98)
    dp(134) = dp(2)*p(39) + p(2)*dp(39) - dp(96)
    dp(135) = dp(4)*p(18) + p(4)*dp(18) - dp(97) - dp(134)
    dp(136) = dp(5)*p(18) + p(5)*dp(18)
    dp(137) = dp(2)*p(40) + p(2)*dp(40) - dp(93) - dp(99) - dp(89)
    dp(138) = dp(4)*p(19) + p(4)*dp(19) - dp(93) - dp(99) - dp(90) - dp(118) - dp(137) - dp(117) &
	&  - dp(99)
    dp(139) = dp(5)*p(19) + p(5)*dp(19) - dp(100)
    dp(140) = dp(7)*p(14) + p(7)*dp(14) - dp(94) - dp(99) - dp(90)
    dp(141) = dp(1)*p(65) + p(1)*dp(65) - dp(132)
    dp(142) = dp(1)*p(66) + p(1)*dp(66) - dp(135) - dp(134)
    dp(143) = dp(4)*p(20) + p(4)*dp(20) - dp(100) - dp(96)
    dp(144) = dp(5)*p(20) + p(5)*dp(20)
    dp(145) = dp(2)*p(44) + p(2)*dp(44) - dp(97) - dp(96) - dp(143)
    dp(146) = dp(2)*p(45) + p(2)*dp(45) - dp(98) - dp(136) - dp(144) - dp(98) - dp(98) - dp(98)
    dp(147) = dp(2)*p(46) + p(2)*dp(46) - dp(100)
    dp(148) = dp(3)*p(10) + p(3)*dp(10) - dp(101) - dp(101) - dp(101)
    dp(149) = dp(8)*p(10) + p(8)*dp(10) - dp(101)
    dp(150) = dp(3)*p(11) + p(3)*dp(11) - dp(83) - dp(102)
    dp(151) = dp(8)*p(11) + p(8)*dp(11) - dp(104)
    dp(152) = dp(3)*p(22) + p(3)*dp(22) - dp(103) - dp(102) - dp(151)
    dp(153) = dp(1)*p(49) + p(1)*dp(49) - dp(103) - dp(102) - dp(152) - dp(103)
    dp(154) = dp(2)*p(69) + p(2)*dp(69) - dp(153) - dp(150)
    dp(155) = dp(8)*p(12) + p(8)*dp(12) - dp(106) - dp(102) - dp(152)
    dp(156) = dp(5)*p(28) + p(5)*dp(28)
    dp(157) = dp(8)*p(14) + p(8)*dp(14) - dp(103)
    dp(158) = dp(1)*p(53) + p(1)*dp(53) - dp(113) - dp(108)
    dp(159) = dp(1)*p(54) + p(1)*dp(54) - dp(114) - dp(110) - dp(109)
    dp(160) = dp(1)*p(55) + p(1)*dp(55) - dp(116) - dp(115)
    dp(161) = dp(1)*p(56) + p(1)*dp(56) - dp(122)
    dp(162) = dp(5)*p(22) + p(5)*dp(22) - dp(111)
    dp(163) = dp(3)*p(24) + p(3)*dp(24) - dp(124) - dp(122) - dp(161) - dp(122)
    dp(164) = dp(1)*p(74) + p(1)*dp(74)
    dp(165) = dp(1)*p(58) + p(1)*dp(58) - dp(124) - dp(122) - dp(163) - dp(124) - dp(122)
    dp(166) = dp(5)*p(23) + p(5)*dp(23) - dp(117)
    dp(167) = dp(1)*p(60) + p(1)*dp(60) - dp(124)
    dp(168) = dp(1)*p(61) + p(1)*dp(61) - dp(137) - dp(129) - dp(126)
    dp(169) = dp(1)*p(62) + p(1)*dp(62) - dp(138) - dp(130) - dp(126)
    dp(170) = dp(5)*p(17) + p(5)*dp(17) - dp(98) - dp(133) - dp(98)
    dp(171) = dp(1)*p(64) + p(1)*dp(64) - dp(140) - dp(130) - dp(129)
    dp(172) = dp(1)*p(67) + p(1)*dp(67) - dp(140) - dp(138) - dp(137)
    dp(173) = dp(7)*p(15) + p(7)*dp(15) - dp(97) - dp(96) - dp(91) - dp(134) - dp(143) - dp(132) &
	&  - dp(96) - dp(134)
    dp(174) = dp(7)*p(16) + p(7)*dp(16) - dp(100) - dp(97) - dp(96) - dp(91) - dp(142) - dp(135) &
	&  - dp(145) - dp(143) - dp(141) - dp(132) - dp(100) &
	&  - dp(97) - dp(96) - dp(91) - dp(135) - dp(145)
    dp(175) = dp(7)*p(17) + p(7)*dp(17) - dp(98) - dp(146) - dp(136) - dp(144) - dp(133) - dp(98) &
	&  - dp(136) - dp(144) - dp(133) - dp(98) - dp(98)
    dp(176) = dp(7)*p(18) + p(7)*dp(18) - dp(98) - dp(146) - dp(98)
    dp(177) = dp(1)*p(76) + p(1)*dp(76) - dp(174) - dp(173)
    dp(178) = dp(7)*p(20) + p(7)*dp(20) - dp(98) - dp(146) - dp(98)
    dp(179) = dp(2)*p(56) + p(2)*dp(56) - dp(126) - dp(121)
    dp(180) = dp(5)*p(24) + p(5)*dp(24) - dp(132)
    dp(181) = dp(2)*p(58) + p(2)*dp(58) - dp(138) - dp(130) - dp(137) - dp(129) - dp(123)
    dp(182) = dp(1)*p(78) + p(1)*dp(78) - dp(180)
    dp(183) = dp(2)*p(60) + p(2)*dp(60) - dp(140) - dp(125)
    dp(184) = dp(9)*p(15) + p(9)*dp(15) - dp(134) - dp(145) - dp(131)
    dp(185) = dp(2)*p(62) + p(2)*dp(62) - dp(135) - dp(143) - dp(132) - dp(128) - dp(174) - dp(135)
    dp(186) = dp(5)*p(27) + p(5)*dp(27) - dp(146) - dp(175)
    dp(187) = dp(9)*p(16) + p(9)*dp(16) - dp(142) - dp(143) - dp(139) - dp(127) - dp(185)
    dp(188) = dp(2)*p(65) + p(2)*dp(65) - dp(146) - dp(133) - dp(175)
    dp(189) = dp(9)*p(18) + p(9)*dp(18) - dp(144)
    dp(190) = dp(1)*p(80) + p(1)*dp(80) - dp(187) - dp(185) - dp(184)
    dp(191) = dp(9)*p(20) + p(9)*dp(20) - dp(136)
    dp(192) = dp(1)*p(69) + p(1)*dp(69) - dp(148)
    dp(193) = dp(3)*p(28) + p(3)*dp(28) - dp(149)
    dp(194) = dp(1)*p(71) + p(1)*dp(71) - dp(152) - dp(151)
    dp(195) = dp(2)*p(81) + p(2)*dp(81) - dp(194)
    dp(196) = dp(1)*p(73) + p(1)*dp(73) - dp(163) - dp(161)
    dp(197) = dp(9)*p(28) + p(9)*dp(28) - dp(196)
    dp(198) = dp(1)*p(77) + p(1)*dp(77) - dp(181) - dp(179) - dp(179)
    dp(199) = dp(2)*p(74) + p(2)*dp(74) - dp(170)
    dp(200) = dp(8)*p(29) + p(8)*dp(29) - dp(198)
    dp(201) = dp(2)*p(76) + p(2)*dp(76) - dp(176) - dp(178) - dp(175)
    dp(202) = dp(2)*p(77) + p(2)*dp(77) - dp(185) - dp(184) - dp(180)
    dp(203) = dp(5)*p(29) + p(5)*dp(29) - dp(188)
    dp(204) = dp(1)*p(82) + p(1)*dp(82) - dp(202)
    dp(205) = dp(7)*p(29) + p(7)*dp(29) - dp(189) - dp(191) - dp(186)
    dp(206) = dp(1)*p(81) + p(1)*dp(81) - dp(193)
    dp(207) = dp(2)*p(82) + p(2)*dp(82) - dp(205) - dp(203)

    return
  end subroutine devpoly

end module dbemsa
