module pes_shell
use bemsa
use dbemsa
use global
implicit none

  real::coeff(1:208) ! change to number of coefficients
                     ! (size of c in bemsa.f90)
  save coeff

contains
  !==================================!
  ! read the coefficients of the PES !
  !==================================!
  subroutine pes_init()
    !::::::::::::::::::
    integer::i

    open(10,file='./coeff-ch4.dat',status='old')

    do i=1,size(coeff)
       read (10,*) coeff(i)
    end do

    return
    close (10)
  end subroutine pes_init

  !====================================!
  ! Function to evaluate the potential !
  !====================================!
   function f(x)
    real,dimension(:),intent(in)::x
    real,dimension(3,size(x)/3)::xyz
    real::f
    !::::::::::::::::::::::::::::::
    real,dimension(size(xyz,2)*(size(xyz,2)-1)/2)::y
    real,dimension(3)::dr
    real::a0  ! the same as the fitting code
    integer::i,j,k,natm

    a0 = 2.0d0

    natm=size(xyz,2)
    xyz = reshape(x,(/3,natm/))

    k = 1
    do i=1,natm-1
       do j=i+1,natm
          dr = xyz(:,i) - xyz(:,j)
          y(k) = sqrt(dot_product(dr,dr))
          k = k+1
       end do
    end do

    do i=1,size(y)
       y(i)=exp(-y(i)/a0)
    end do

    f=emsav(y,coeff)

    return
  end function f

end module pes_shell
